/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessStatusEvent;
import filenet.vw.toolkit.utils.ws.contact.VWUDDIBusinessContactDialog;
import filenet.vw.toolkit.utils.ws.contact.VWUDDIBusinessContactsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;

public class VWUDDIBusinessContactsPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private Contacts m_contacts;
    private Frame m_parentFrame = null;
    private boolean m_bChanged = false;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_contactTable = null;
    private VWUDDIBusinessContactsTableModel m_tableModel = null;
    private boolean m_bEnableControls = true;
    private BusinessEntity m_regionBusinessEntity = null;
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private boolean m_bIsReginBusinessEntity = false;
    private EventListenerList m_listenerList = null;

    public VWUDDIBusinessContactsPanel(Frame parent, Contacts contactList) {
        this.m_parentFrame = parent;
        this.m_bIsReginBusinessEntity = true;
        this.m_contacts = contactList;
        this.init(null);
    }

    public VWUDDIBusinessContactsPanel(Frame parent, VWUDDIBusinessItem businessItem, BusinessEntity regionBusinessEntity) {
        try {
            this.m_parentFrame = parent;
            this.m_bIsReginBusinessEntity = false;
            this.m_vwBusinessItem = businessItem;
            if (this.m_vwBusinessItem != null) {
                this.m_contacts = this.m_vwBusinessItem.getContacts();
            }
            this.init(regionBusinessEntity);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void init(BusinessEntity regionBusinessEntity) {
        try {
            this.m_regionBusinessEntity = regionBusinessEntity;
            this.m_listenerList = new EventListenerList();
            this.createControls();
            this.m_contactTable.clearSelection();
            if (this.m_contactTable.getRowCount() > 0) {
                this.m_contactTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 131072));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 1));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_tableModel.addBusinessStatusListener(listener);
        this.m_listenerList.add(IVWUDDIBusinessStatusListener.class, listener);
    }

    public boolean hasChanged() {
        this.stopTableEditing();
        return this.m_bChanged || this.m_tableModel.hasChanged();
    }

    public boolean stopTableEditing() {
        if (this.m_contactTable != null) {
            this.m_contactTable.stopEditing();
        }
        return true;
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopTableEditing();
            if (this.hasChanged() && (bSuccess = this.m_tableModel.verifyContacts())) {
                Vector contactList = this.m_tableModel.getContactVector();
                if (contactList != null && contactList.size() > 0) {
                    if (this.m_contacts == null) {
                        this.m_contacts = new Contacts();
                    }
                    this.m_contacts.setContactVector(contactList);
                } else {
                    this.m_contacts = null;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
        }
        return bSuccess;
    }

    public void updateContactInfo(VWUDDIBusinessItem businessItem) {
        try {
            this.stopEditing();
            this.m_vwBusinessItem = businessItem;
            this.m_contacts = this.m_vwBusinessItem.getContacts();
            if (this.m_contacts != null && this.m_contacts.getContactVector() == null) {
                this.m_contacts.setContactVector(new Vector());
            }
            this.m_tableModel.setVWBusinessItem(this.m_vwBusinessItem);
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_contactTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_contactTable.getSelectedRow()) {
                    this.m_contactTable.clearSelection();
                }
                this.m_contactTable.setRowSelectionInterval(nRow, nRow);
                this.m_contactTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (this.m_bEnableControls && !event.getValueIsAdjusting()) {
            this.adjustToolbarButtonsState();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopTableEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_contactTable.setRowSelectionInterval(nRow, nRow);
                    this.m_contactTable.setColumnSelectionInterval(0, 0);
                    this.m_contactTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 65536: {
                    this.onImport();
                    break;
                }
                case 131072: {
                    this.onAdvancedOperations();
                    break;
                }
                case 1: {
                    this.onUp();
                    break;
                }
                case 2: {
                    this.onDown();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createContactsPanel();
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Contacts getContacts() {
        Vector contactVector = this.m_tableModel.getContactVector();
        if (contactVector == null || contactVector.size() <= 0) {
            this.m_contacts = null;
            return this.m_contacts;
        }
        if (this.m_contacts == null) {
            this.m_contacts = new Contacts();
        }
        this.m_contacts.setContactVector(contactVector);
        return this.m_contacts;
    }

    public Vector getContactVector() {
        return this.m_tableModel.getContactVector();
    }

    public Contact[] getContactList() {
        return this.m_tableModel.getContacts();
    }

    public void stopEditing() {
        if (this.m_contactTable != null) {
            this.m_contactTable.stopEditing();
        }
    }

    public boolean verifyContacts() {
        return this.m_tableModel.verifyContacts();
    }

    public void enableControls(boolean bEnable) {
        this.m_bEnableControls = bEnable;
        this.m_tableModel.setCellEditable(this.m_bEnableControls);
        if (this.m_bEnableControls) {
            if (this.m_contactTable.getRowCount() > 0) {
                this.m_contactTable.setRowSelectionInterval(0, 0);
            }
            this.adjustToolbarButtonsState();
        } else {
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 16));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 131072));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 1));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 2));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 65536));
        }
    }

    public void releaseResources() {
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_contactTable != null) {
            this.m_contactTable.removeAll();
            this.m_contactTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWUDDIBusinessStatusListener.class, (IVWUDDIBusinessStatusListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.removeAll();
    }

    private void createContactsPanel() {
        try {
            int options = 268566547;
            if (!this.m_bIsReginBusinessEntity && this.m_regionBusinessEntity != null) {
                options |= 0x10000;
            }
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_businessContact, options);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this, VWResource.s_businessContact, VWResource.s_businessContact);
            this.m_tableModel = this.m_bIsReginBusinessEntity ? new VWUDDIBusinessContactsTableModel(this.m_parentFrame, this.m_contacts) : new VWUDDIBusinessContactsTableModel(this.m_parentFrame, this.m_vwBusinessItem);
            this.m_tableModel.addTableModelListener(this);
            this.m_contactTable = new VWTable(this.m_tableModel);
            this.m_contactTable.setRowSelectionAllowed(true);
            this.m_contactTable.getSelectionModel().addListSelectionListener(this);
            this.m_contactTable.getSelectionModel().setSelectionMode(0);
            this.m_contactTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            this.m_contactTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn tcElement = this.m_contactTable.getColumn(this.m_tableModel.getColumnName(0));
            if (tcElement != null) {
                tcElement.setMaxWidth(20);
            }
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_contactTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_contactTable, this, VWResource.s_contacts, VWResource.s_contacts);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopTableEditing();
            int[] rows = this.m_contactTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_contactTable.getSelectedRow();
            int nColumnIndex = this.m_contactTable.getSelectedColumn();
            if (nRowIndex > 0) {
                this.m_tableModel.up(nRowIndex);
                this.m_contactTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_contactTable.getSelectedRow();
            int nColumnIndex = this.m_contactTable.getSelectedColumn();
            if (nRowIndex < this.m_tableModel.getRowCount() - 1) {
                this.m_tableModel.down(nRowIndex);
                this.m_contactTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onImport() {
        if (this.m_regionBusinessEntity == null) {
            return;
        }
        Contacts regionContacts = this.m_regionBusinessEntity.getContacts();
        if (regionContacts == null) {
            return;
        }
        Vector regionContactVector = regionContacts.getContactVector();
        int regionContactSz = regionContactVector.size();
        if (regionContactSz <= 0) {
            return;
        }
        Vector<Contact> currentContactVector = this.m_tableModel.getContactVector();
        if (currentContactVector == null) {
            currentContactVector = new Vector<Contact>();
            this.m_tableModel.setContactVector(currentContactVector);
        }
        boolean bImported = false;
        for (int i = 0; i < regionContactSz; ++i) {
            Contact regionContactItem = (Contact)regionContactVector.elementAt(i);
            if (regionContactItem == null) continue;
            int currentContactSz = currentContactVector.size();
            if (currentContactSz <= 0) {
                currentContactVector.add(regionContactItem);
                continue;
            }
            String regionContactName = regionContactItem.getPersonNameValue();
            String regionContactType = regionContactItem.getUseType();
            Contact contactItem = null;
            boolean bFound = false;
            for (int j = 0; j < currentContactSz; ++j) {
                String userType;
                String contactName;
                contactItem = (Contact)currentContactVector.elementAt(j);
                if (contactItem == null || (contactName = contactItem.getPersonNameValue()) == null || regionContactName.compareTo(contactName) != 0 || (userType = contactItem.getUseType()) == null || regionContactType == null || regionContactType.compareTo(userType) != 0) continue;
                bFound = true;
                currentContactVector.insertElementAt(regionContactItem, j);
                currentContactVector.remove(contactItem);
                bImported = true;
                break;
            }
            if (bFound) continue;
            currentContactVector.add(regionContactItem);
            bImported = true;
        }
        if (bImported) {
            this.m_bChanged = true;
            if (this.m_vwBusinessItem != null) {
                this.m_vwBusinessItem.setModified(this.m_bChanged);
            }
            this.BusinessChanged(1);
            this.updateUI();
        }
    }

    private void onAdvancedOperations() {
        try {
            this.stopEditing();
            int rowIndex = this.m_contactTable.getSelectedRow();
            Vector theContacts = this.m_tableModel.getContactVector();
            if (theContacts != null && theContacts.size() > 0) {
                VWUDDIBusinessContactDialog contactDialog = new VWUDDIBusinessContactDialog(this.m_parentFrame, theContacts, rowIndex);
                contactDialog.setVisible(true);
                if (contactDialog.getStatus() == 0 && contactDialog.hasChanged()) {
                    Vector retContacts = contactDialog.getContactVector();
                    this.m_tableModel.setContactVector(retContacts);
                    this.m_bChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bChanged);
                    }
                    this.BusinessChanged(1);
                }
                contactDialog.releaseResources();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void adjustToolbarButtonsState() {
        JPanel clientPanel = this.m_toolBarBorder.getClientPanel();
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 16));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 1));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 2));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x10000000));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 131072));
        int nRowIndex = this.m_contactTable.getSelectedRow();
        int nRowCount = this.m_contactTable.getRowCount();
        if (this.m_tableModel != null && nRowIndex != -1) {
            if (nRowIndex > 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 1));
            }
            if (nRowIndex < nRowCount - 1) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 2));
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x10000000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 131072));
        }
    }

    private void BusinessChanged(int evtType) {
        Object[] listeners = this.m_listenerList.getListenerList();
        VWUDDIBusinessStatusEvent evt = new VWUDDIBusinessStatusEvent(this, this.m_vwBusinessItem, evtType);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWUDDIBusinessStatusListener.class) continue;
            ((IVWUDDIBusinessStatusListener)listeners[i + 1]).businessChanged(evt);
        }
    }
}

